<?php

class Piwik_BourneliPlugin_API
{
    static private $instance = null;
    /**
     * @return Piwik_VisitsSummary_API
     */
    static public function getInstance()
    {
        if (self::$instance == null)
        {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function getDemoData( $idSite, $period, $date, $segment = false )
    {
        $dt = new Piwik_DataTable();
        $dt->addRowFromSimpleArray(array('col1'=>1, 'col2' =>2));
        return $dt;
    }

    public function fakePieDataTable($idSite, $period, $date, $segment = false)
    {
        $refererVisits = array(
            '直接访问' => 101,
            'QFS搜索插件' => 200,
            'ATT广告引导' => 25,
            'pub.code.oa.com引导' => 15,
        );

        $dt = new Piwik_DataTable();
        $dt->addRowsFromArrayWithIndexLabel($refererVisits);
        return $dt;
    }

    public function fakeCategoryVisit($idSite, $period, $date, $segment = false)
    {
        $data = array(
            'ATT'           => 1068,
            'QFS'           => 488,
            '办公流程'        => 347,
            'ARS'           => 338,
            'PHP单元测试'     => 198,
            'Minnow'        => 191,
            'C++单元测试'     => 176,
            'TCMS'          => 135,
            '开发技术'        => 111,
            'CIS'           => 94,
            '定时调度'        => 75,
            '生活问题'        => 37,
            '工作相关'        => 36,
        );

        $dt = new Piwik_DataTable();
        $dt->addRowsFromArrayWithIndexLabel($data);
        return $dt;
    }

    public function fakeVisitWithTime($idSite, $period, $date, $segment = false)
    {
        $data = array();
        for($i=0; $i<20; ++$i)
        {
            $data[$i] = array(
                'pv' => rand(50, 100),
                'uv' => rand(10, 80),
                'mv' => rand(1, 90)
            );
        }

        $dt = new Piwik_DataTable();
        $dt->addRowsFromArrayWithIndexLabel($data);
        return $dt;
    }
}